import java.util.Scanner;

public class Listing12_5
{
   public static void main(String[] args)
   {
      // Tworzymy obiekt Scanner, aby odczytać dane wprowadzone na klawiaturze
      Scanner keyboard = new Scanner(System.in);
      
      // Stała równa minimalnej długości hasła
      final int MIN_LENGTH = 8;
          
      // Zmienna lokalna, w której zapiszemy hasło wprowadzone przez użytkownika
      String password;
      
      // Wyświetlamy informacje na temat programu
      System.out.println("Program sprawdza, czy wprowadzone hasło");
      System.out.println("spełnia następujące wymagania:");
      System.out.println("(1) Hasło musi się składać z co najmniej 8 znaków.");
      System.out.println("(2) Hasło musi zawierać co najmniej 1 dużą literę.");
      System.out.println("(3) Hasło musi zawierać co najmniej 1 małą literę.");
      System.out.println("(4) Hasło musi zawierać co najmniej 1 cyfrę.");
      System.out.println();
      
      // Pobieramy hasło od użytkownika
      System.out.print("Wprowadź hasło.");
      password = keyboard.nextLine();
    
      // Walidujemy hasło
      if (password.length() >= MIN_LENGTH && 
          numberUpperCase(password) >= 1 &&
          numberLowerCase(password) >= 1 && 
          numberDigits(password) >= 1)
      {
          System.out.println("Hasło jest prawidłowe.");
      }
      else
      {
         System.out.println("Hasło nie spełnia wymagań.");
      }
   }
   
   // Metoda numberUpperCase przyjmuje jako argument
   // łańcuch znakowy i zwraca liczbę występujących w nim
   // dużych liter
   public static int numberUpperCase(String str)
   {
      // Zmienna, w której zapiszemy liczbę dużych liter
      int count = 0;
      
      // Zmienna, za pomocą której będziemy śledzić poszczególne znaki w łańcuchu str
      int index;
      
      // Śledzimy poszczególne znaki w łańcuchu
      // i zliczamy duże litery
      for (index = 0; index <= str.length() - 1; index++)
      {
          if (Character.isUpperCase(str.charAt(index)))
          {
             count = count + 1;
          }
      }
      
      // Zwracamy liczbę dużych liter
      return count;
   }

   // Metoda numberLowerCase przyjmuje jako argument
   // łańcuch znakowy i zwraca liczbę występujących w nim
   // małych liter
   public static int numberLowerCase(String str)
   {
      // Zmienna, w której zapiszemy liczbę małych liter
      int count = 0;
      
      // Zmienna, za pomocą której będziemy śledzić poszczególne znaki w łańcuchu str
      int index;
      
      // Śledzimy poszczególne znaki w łańcuchu
      // i zliczamy małe litery
      for (index = 0; index <= str.length() - 1; index++)
      {
          if (Character.isLowerCase(str.charAt(index)))
          {
             count = count + 1;
          }
      }
      
      // Zwracamy liczbę małych liter
      return count;
   }

   // Metoda numberDigits przyjmuje jako argument
   // łańcuch znakowy i zwraca liczbę występujących w nim
   // cyfr
   public static int numberDigits(String str)
   {
      // Zmienna, w której zapiszemy liczbę cyfr
      int count = 0;
      
      // Zmienna, za pomocą której będziemy śledzić poszczególne znaki w łańcuchu str
      int index;
      
      // Śledzimy poszczególne znaki w łańcuchu
      // i zliczamy cyfry
      for (index = 0; index <= str.length() - 1; index++)
      {
          if (Character.isDigit(str.charAt(index)))
          {
             count = count + 1;
          }
      }
      
      // Zwracamy liczbę cyfr
      return count;
   }
}
